<?php
if(!isset($_SESSION['admin_panel']) or empty($_SESSION['admin_panel']) OR strlen($_SESSION['admin_panel']) != 32) {
    print 'Not logged in';
    exit;
}


if(isset($_GET['del'])) {
	$id = (int) $db->escape(trim(strip_tags($_GET['del'])));
	$db->query("DELETE FROM affiliates WHERE affEarnID = $id");
	print '<div class="alert alert-error">Affiliate data removed</div>';
}

?>

<h4>Affiliates : Here you generate a PayPal MassPay File for a selected period.</h4>

<?php

if(isset($_POST['sbdate']) && isset($_POST['confirm'])) {
    
    /* Data to be inserted into excel in an array of arrays
     * Each array is the avg monthly temp of a different city */
     
     /*
      * In the first column, enter your recipients’ email addresses. 
      * In the second column, enter the payment amounts for each recipient. 
      * In the third column, input the three-letter currency code for the currency of the payment
      */
    $order_m = $db->escape(trim(strip_tags($_POST['m'])));
    $order_y = $db->escape(trim(strip_tags($_POST['y'])));
    
    $data_sql = $db->get_results("SELECT affID, paypal_email as email, 
    						FORMAT(SUM(amount), 2) as t_amount, status    
    						FROM affiliates, users, advertisers  
    						 WHERE month = '$order_m'
                             AND year = '$order_y' 
                             AND affiliates.affID = users.userID 
                             AND advertisers.status != 'Pending' 
        					 AND affiliates.cID = advertisers.advID 
        					 AND users.paypal_email != ''
                             GROUP BY affID  HAVING t_amount >= 0 ");//add pending condition 
     
    if(!count($data_sql)) {
        
        print 'Nothing to generate.';
        
    }else{
    	
    ob_clean();
    
    $revenues = array();
    
	foreach($data_sql as $email) {
		$revenues[$email->affID] = array(0 => $email->email, 1 => $email->t_amount, 2 => 'USD');
	}
    
    $data = $revenues;
      
    #$titleArray = array_keys((array) $data[0]);
    
    //Delimited {TAB} 
    $delimiter = "\t";
    
    //Set target filename - see above comment on file extension.
    $filename="Payments".microtime().".tsv";
      
    //Send headers
    header("Content-type: application/octet-stream");
    header("Content-Disposition: attachment; filename=$filename");
    header("Pragma: no-cache");
    header("Expires: 0");
      
    //Separate each column title name with the delimiter
    #$titleString = implode($delimiter, $titleArray);
    #print $titleString . "\r\n";
      
    //Loop through each subarray, which are our data sets
    foreach ($data as $subArrayKey => $subArray) {
        //Separate each datapoint in the row with the delimiter
        $dataRowString = implode($delimiter, (array) $subArray);
        print $dataRowString . "\r\n";
    }
    exit;
    
    } 
    
}elseif(isset($_POST['sbdate'])){
    //confirmation
    printf("<div class=alert alert-error>You have selected to generate a MassPay For <strong>%s</strong>!</div>", 
            $_POST['m'] . ' ' . $_POST['y']);
    ?>
    <form method="POST" action="">
        <input type="hidden" name="m" value="<?php print $_POST['m']; ?>" />
        <input type="hidden" name="y" value="<?php print $_POST['y']; ?>" />
        <input type="hidden" name="confirm" value="true" />
    <input type="submit" name="sbdate" value="I Confirm!" class="btn btn-large" style="margin-top:-5px;"/>
</form>
    <?php
}else{
    
    $months = array('Jan' => 'Jan', 'Feb' => 'Feb',
                    'Mar' => 'Mar', 'Apr' => 'Apr', 
                    'May' => 'May', 'Jun' => 'Jun',
                    'Jul' => 'Jul', 'Aug' => 'Aug',
                    'Sep' => 'Sep', 'Oct' => 'Oct',
                    'Nov' => 'Nov', 'Dec' => 'Dec');
    ?>
    <form method="POST" action="">
    <label>Choose month &amp; year :</label> 
    <select name="m">
        <?php
        foreach($months as $month) {
            if($month == date("M")) {
                print '<option value="'.$month.'" selected="">'.$month.'</option>';
            }else{
                print '<option value="'.$month.'">'.$month.'</option>';
            }
            print "\n";
        }
                      
        ?>
    </select>
    <select name="y">
        <?php
        for($years = 2012; $years <= date("Y"); $years++) {
            if($years == date("Y")) {
                print '<option value="'.$years.'" selected="">'.$years.'</option>';
            }else{
                print '<option value="'.$years.'">'.$years.'</option>';
            } 
        }
        ?>
    </select>
    <input type="submit" name="sbdate" value="Go" class="btn" style="margin-top:-5px;"/>
</form>
    <?php
}


                                
?>